ComponentNames.FrontendModule = 'FrontendModule';
ComponentNames.BackendModule = 'BackendModule';
ComponentNames.SeoModule = 'SeoModule';
ComponentNames.AuthenticationModule = 'AuthenticationModule';
ComponentNames.ContentManagementModule = 'ContentManagementModule';
ComponentNames.ApiClientModule = 'ApiClientModule';
ComponentNames.PaymentGatewayModule = 'PaymentGatewayModule';
ComponentNames.VideoPlaybackModule = 'VideoPlaybackModule';
ComponentNames.StorageModule = 'StorageModule';
ComponentNames.EmailModule = 'EmailModule';
ComponentNames.LocalizationModule = 'LocalizationModule';
ComponentNames.SearchModule = 'SearchModule';
ComponentNames.BandwidthCompressionModule = 'BandwidthCompressionModule';
ComponentNames.SmallVirtualServer = 'SmallVirtualServer';
ComponentNames.MediumVirtualServer = 'MediumVirtualServer';
ComponentNames.LargeVirtualServer = 'LargeVirtualServer';
ComponentNames.DatabaseLayer = 'DatabaseLayer';
ComponentNames.InputModule = 'InputModule';
ComponentNames.NotificationModule = 'NotificationModule';
ComponentNames.InterfaceModule = 'InterfaceModule';

Components.push({
    name: ComponentNames.InterfaceModule,
    employeeLevel: EmployeeLevels.Beginner,
    icon: 'images/icons/modules/webdesign.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        BlueprintComponent: 1,
        WireframeComponent: 1,
        GraphicsComponent: 1
    }
});

Components.push({
    name: ComponentNames.FrontendModule,
    employeeLevel: EmployeeLevels.Beginner,
    icon: 'images/icons/modules/frontend.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        UiComponent: 1,
        InterfaceModule: 1
    }
});

Components.push({
    name: ComponentNames.BackendModule,
    employeeLevel: EmployeeLevels.Beginner,
    icon: 'images/icons/modules/backend.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        BackendComponent: 1,
        NetworkComponent: 1
    }
});

Components.push({
    name: ComponentNames.ContentManagementModule,
    employeeLevel: EmployeeLevels.Beginner,
    icon: 'images/icons/modules/contentmanagement.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        DatabaseComponent: 1,
        BackendModule: 1
    }
});

Components.push({
    name: ComponentNames.InputModule,
    employeeLevel: EmployeeLevels.Beginner,
    icon: 'images/icons/modules/input.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        UiComponent: 1,
        BackendComponent: 1
    }
});

Components.push({
    name: ComponentNames.SeoModule,
    employeeLevel: EmployeeLevels.Intermediate,
    icon: 'images/icons/modules/seo.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        FrontendModule: 1,
        SemanticComponent: 1
    }
});


Components.push({
    name: ComponentNames.AuthenticationModule,
    employeeLevel: EmployeeLevels.Beginner,
    icon: 'images/icons/modules/authentication.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        DatabaseComponent: 1,
        EncryptionComponent: 1,
        BackendModule: 1
    }
});

Components.push({
    name: ComponentNames.ApiClientModule,
    employeeLevel: EmployeeLevels.Intermediate,
    icon: 'images/icons/modules/apiclient.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        BackendModule: 1,
        NetworkComponent: 1,
    }
});


Components.push({
    name: ComponentNames.PaymentGatewayModule,
    employeeLevel: EmployeeLevels.Expert,
    icon: 'images/icons/modules/payment.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        BackendModule: 1,
        ApiClientModule: 1,
    }
});

Components.push({
    name: ComponentNames.VideoPlaybackModule,
    employeeLevel: EmployeeLevels.Intermediate,
    icon: 'images/icons/modules/video.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        VideoComponent: 1,
        FrontendModule: 1,
        BackendModule: 1,
    }
});

Components.push({
    name: ComponentNames.StorageModule,
    employeeLevel: EmployeeLevels.Intermediate,
    icon: 'images/icons/modules/storage.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        FilesystemComponent: 1,
        BackendComponent: 1
    }
});

Components.push({
    name: ComponentNames.EmailModule,
    employeeLevel: EmployeeLevels.Intermediate,
    icon: 'images/icons/modules/email.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        SmtpComponent: 1,
        BackendComponent: 1
    }
});

Components.push({
    name: ComponentNames.LocalizationModule,
    employeeLevel: EmployeeLevels.Expert,
    icon: 'images/icons/modules/localization.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        I18nComponent: 1,
        FrontendModule: 1
    }
});

Components.push({
    name: ComponentNames.SearchModule,
    employeeLevel: EmployeeLevels.Expert,
    icon: 'images/icons/modules/search.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        DatabaseComponent: 1,
        SearchAlgorithmComponent: 1,
        BackendComponent: 1,
    }
});

Components.push({
    name: ComponentNames.BandwidthCompressionModule,
    employeeLevel: EmployeeLevels.Expert,
    icon: 'images/icons/modules/compression.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        CompressionComponent: 1,
        NetworkComponent: 1,
        BackendComponent: 1,
    }
});

Components.push({
    name: ComponentNames.DatabaseLayer,
    employeeLevel: EmployeeLevels.Intermediate,
    icon: 'images/icons/modules/datalayer.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        DatabaseComponent: 1,
        BackendComponent: 1,
        NetworkComponent: 1,
    }
});

Components.push({
    name: ComponentNames.NotificationModule,
    employeeLevel: EmployeeLevels.Intermediate,
    icon: 'images/icons/modules/notification.png',
    type: ComponentTypes.Module,
    employeeTypeName: EmployeeTypeNames.Developer,
    requirements: {
        UiComponent: 1,
        BackendComponent: 1,
        EmailModule: 1,
    }
});